<?php  
if ($_SERVER['REQUEST_METHOD'] == 'POST') {  
    $json = file_get_contents('php://input');  
    $data = json_decode($json, true);  

    if (isset($data['id']) && isset($data['image'])) {  
        $id = $data['id'];  
        $imageData = $data['image'];  

        if (strpos($imageData, 'data:image/png;base64,') === 0) {  
            $imageData = str_replace('data:image/png;base64,', '', $imageData);  
        }  

        $decodedImage = base64_decode($imageData);  

        $fileName = "uploads/screenshot_$id.png";  
        if (file_put_contents($fileName, $decodedImage)) {  
            echo json_encode(['status' => 'success', 'message' => 'Image uploaded successfully.']);  
        } else {  
            echo json_encode(['status' => 'error', 'message' => 'Failed to save image.']);  
        }  
    } else {  
        echo json_encode(['status' => 'error', 'message' => 'Invalid input.']);  
    }  
} else {  
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);  
}  
?>  